% Tactical Battle Changelog

## version 2.0
1. Added an apply_ordinal flag to point files.  This allows you to control the order in which point causers are applied.  Useful in some advanced situations where a unit who runs out of shields transforms into a new unit without shields and you don't want another point causer to be applied to it.
2. Various performance enhancements to help the game run more smoothly.
3. Fixed a bug where pressing Alt+O to switch the output type to screen reader would sometimes need you to alt+tab away and back to the window to get NVDA to read it. 
4. Fixed a bug where if a unit died due to an effect applied by a script, we don't accidentally kill them again. 
5. Added a shared.RemoveEffect function for scripters to remove effects in a way that will still trigger effect after removed logic and also read out effect removed messages if the effect requires it. 
6. Added a unit.DoDamageTo function that allows a unit to do damage to another unit's point with a given damage type, taking into account modifiers on both the attacker and the defender. 
7. Added a unit.DoRestoreTo function that allows a unit to restore another unit's points, taking into account modifiers on both the attacker and the defender. 
8. Added an AllFlags hash to units, skills, items and effects that allows scripters to get the values of the flags as set in the files with map overrides taken into account. 
9. Implemented after_item_equipped and after_item_unequipped scripting events.
10. Fixed a potential problem with date and times when downloading map campaigns.
11. Added a new global javascript function, randomSound(string), to let scripters use the same random sound logic that is used in game. 
12. Fixed a bug where putting none in a unit's terrain_limit flag would be ignored and the unit wouldn't be able to move on none terrain.
13. Introduced an impassable_terrain property for units, which works like an inverse terrain_limit. If both are specified, impassable_terrain is taken by default as it's likely to be smaller.
14. Renamed terrain_limit to passable_terrain in documentation and in code. The flag terrain_limit will still work for backwards compatibility, but with the introduction of impassable_terrain, passable_terrain felt like a more natural name for its opposite counterpart. 
15. Added an enable_friendly_fire boolean flag to maps. This is true by default. Can be set to false either by specifying enable_friendly_fire=false or disable_friendly_fire on a map. When set to false, splash damage does not effect units on the same team as the skill user. 
16. Added a can_friendly_fire flag to skills. This is false by default. This serves to override disable_friendly_fire at a skill level. Skills with this set will still cause friendly fire damage even when on a map with disable_friendly_fire. 
17. Updated documentation to include UnitPoint.LookupName, which was exposed but not mentioned. Can be used to see the point's name, as you can imagine. May be useful for script debugging, as much as anything else. 
18. Added a before_point_damage and after_point_damage script event for scripters. Before point damage should return an object with wasHandled set to false or true, dependent on whether the scripter wants the rest of that point's damaging logic to occur. Kind of like a mini-version of override causers.
19. Put in a change so that we no longer announce the turns of teams that have no units on the map. Having verbose in your game.config will mean you still hear the turns of these teams, but otherwise these teams's turns will pass silently. 
20. Implemented shared.GetEffectObjectByName, shared.GetSkillObjectByName, shared.GetItemObjectByName and shared.GetUnitObjectByName functions for scripters to get at the respective objects of a map pack without them needing to be parsed in to a function. 
21. Fixed a bug for edge cases where an effect or item adds a damage type not already present to a skill or item attack, which would mean any protection against that added damage type would be ignored. 
22. Added add_skills and remove_skills flags to skills, items and effects. These will grant or remove use of a skill to a unit. In the case of an effect, this is only for the duration of the effect. 
23. Added a hidden flag to effects, which allows them to not be announced in the Unit Information. 
24. Added shared.AddSkillToUnit and shared.RemoveSkillFromUnit to the shared object for scripters. 
25. Added equip_add_skills and equip_remove_skills to items, which allow skills to be added or removed as an item is equipped. 
26. Fixed a bug that caused a crash whenever someone attempted to add or a remove a skill from the same unit using a hotkey. 
27. Implemented a shared.CreateItem function for scripters, so they can create new items before putting them in unit or tile inventories. 
28. Documented Inventory and Item objects in the scripting documentation, as I noticed it hadn't been yet. 
29. Made it so that hidden effects are not announced on tiles when the review cursor is moved over them in the battle map. 
30. Exposed the Map.Teams hash to scripters. 
31. Documented Map.CurrentTeam and Map.PlayerTeam for scripters. Were already exposed, but worth mentioning. 
32. Exposed the following team properties to scripters: Number, Name, Friends and Enemies.
33. Made it so that tile, effect and tile step sounds don't play for flying units, since they're flying and wouldn't cause stepping ssounds.
34. Introduced a storyline flag to map pack settings. If specified, maps are unlocked in the map pack 1 at a time, meaning a player has to complete the previous map before they move onto the next one. This persists across game restarts. 
35. Added a storyline_starts_at flag to map pack settings, allowing map pack authors to specify what the last map is before the other maps have to be unlocked. 
36. In storyline map packs, after a map has been completed and if it's not the last map in the storyline, we give a "go to next map" option as the first option on the victory screen. 
37. Had a bit of a rewrite around adding or removing skills, which should fix a bug around accidentally removing a skill from all users of a skill.
38. Fixed a bug where sight range mods could put a unit's sight range below 0, meaning that a unit cannot even see itself. 
39. Moved shared.CreateItem function from the shared object to the Inventory object, it's now Inventory.CreateAndAddItem(itemName). This has several benefits, including not needing to take as many steps to add an item to a unit or tile. 
40. Documented FriendlyType for units and FriendlyName for skills, items, effects and terrains, since I noticed they weren't. 
41. Changed AI summoning logic to pick one of its useable summoning skills at random.
42. Added a description of unit inheritance into the map making documentation
43. Made it so that start and end turn restores and step restores will respect point_ignore_max.
44. Fixed a bug where using friendly skills on units from teams set as a friend team of the user was considered invalid. Similarly, using enemy skills on said same units was considered valid when it shouldn't be. This should now be fixed.
45. Fixed a bug where it was possible to do damage to a unit after they'd been removed from the map, causing additional AtZero effects to be calculated. This particularly caused problems in the case of AtZero effects coupled with the transforms_into script.
46. Fixed a bug where the AI would attack units that have been removed from the map by the previous turn from the same AI unit.
47. Fixed a reported enumeration modified exception that could cause a crash.
48. Added a no_announce flag to skills and items, which will prevent the game announcing their usage, for players that want to manually handle that side of thing through script flags.
49. Added an after_unit_move script event.
50. Fixed a bug where after_effect_fizzled script events weren't firing for tile effects when used in the new script flag syntax
51. Added a silence_changes flag to points files, allowing map creators to suppress announcement of point restores or inflicts on that point.
52. Exposed Unit.GetEquippedItems to scripters.
53. Exposed Unit.Flying and documented Unit.IsFlying() to scripters.
54. Fixed a bug where you could press enter/space on an unseen/unexplored tile and view the menu of a unit there.
55. Fixed a bug where friendly_name wouldn't parse on terrain.
56. Documented how to use sound for map intro_text, victory_text and defeat_text in the map making guide.
57. Documented Tile.Terrain for scripters. It seems it was already there, even with ScriptFlags.
58. Fixed a bug where point inflictions caused by effects wouldn't play nicely with before_point_damage and after_point_damage.
59. Documented the readonly properties item.Stackable, item.Equippable, and item.Useable. 
60. Implemented a self_add_skills and self_remove_skills flag, to add or remove skills to or from the user of a skill.
61. Exposed map.GetAdjacentTiles and map.GetDistanceBetweenTiles to scripters, to help them find out map based info.
62. Fixed a bug where effects that were not marked as unit would still be announced as being applied to a unit when a unit is on the tile it effects.
63. Implemented an effect_immunities flag, that is useable on units, effects, passive skills and equipped items, to grant immunity from an effect.
64. Made it so that skills for giving, taking, dropping or using items or managing equipment will now play a sound if one is set, though this will not be heard by other players in multiplayer.
65. Fixed a bug where items that kill their user on use and the user has no_drop_items_on_death would cause crashes in multiplayer.
66. Added an item take_sound flag, to play a sound when you pick up an item.
67. Implemented an insufficient_points_message flag for points, that allows you to customize the message spoken when trying to use a skill that you don't have enough points for.
68. Fixed a bug where point friendly names weren't being used when reading inflict or restore messages.
69. Fixed a bug where silenced point changes might still be announced over multiplayer.
70. Made it so that while waiting for another human player to take their turn in multiplayer, you will hear sounds and messages, regardless of your battle log settings. AI turns will still not be announced until the battle log. If you have battle log on, you will still get the battle log at the end of the turn.
71. Made it so that passive skills can also have the impassable flag on them, to make a unit or structure impassable.
72. Introduced a tile.IsValidDestinationFor function for scripters, which incorporates the tile.CanHold logic as well as passable and flyable terrain checks.
73. Fixed a bug where splash effects that weren't able to be added due to effect immunities or the effect applying skill killing the target unit caused a crash.
74. Fixed a bug where effects wouldn't be passed through to AfterPointDamage scripts in some instances
75. Implemented an announce_death flag for units and structures, that defaults to true. When false, the "* has been defeated" message on the unit or structure's death will not be announced.
76. Implemented an ignored_by_other_ai flag for units and structures, to say that other AI controlled teams will ignore this unit as a friend or enemy.
77. Implemented an ignored_for_victory_conditions flag for units and structures, to say that when there are no special victory/defeat conditions set for a map, this unit or structure is not counted towards a team's surviving units when calculating victory or defeat.
78. Implemented an is_skill_or_item_usable pair of flags, both before a target is picked and after a target is picked. This allows a scripter to add additional logic for checking whether a given skill or item is useable.
79. Fixed some instances where using unit.DoDamageTo wasn't calling BeforePointDamage and AfterPointDamage scripts
80. Fixed an issue where the initial value of the sliders in the settings screen wouldn't announce itself. Thanks Ian for handling this.
81. Fixed an issue with empty battle log messages crashing the game.
82. Fixed an issue with effect_immunities flags that use an equals sign along with multiple-word effects. This should work fine now.

### Multiplayer
1. Reintroduced online multiplayer. Massive amounts of code change for this.
2. Removed the option to load a saved multiplayer game, for now.
3. Added a who is online option to the multiplayer menu that will list all online players.
4. Added a multiplayer and a multiplayer_only flag to map packs. Multiplayer allows it to show up when selecting a map to host for a multiplayer game. multiplayer_only also prevents it from showing up in the single player map pack selection screen.
5. Some significant improvements to only playing speech/sound for things that the player can see.
6. Allow game creaters to rename any unit/structure on the map. Other players can rename any unit on their team. Names that players who aren't the creater give to units who aren't on their team won't be seen by other players in multiplayer.
7. Hide games that need map packs that the user doesn't have.
8. If a client player leaves during a game, the other players will receive a message and their team will be switched to run as AI.
9. Added some multiplayer documentation to the user guide. 
10. Made it so that the server announces newly created games to players who aren't currently in a game

## version 2.0
1. Added the player_team= map flag to specify which team is controlled by the player.
2. Fixed a bug where AI would sometimes attack units that were already dead and removed from the map.
3. Added after_effect_applied, after_effect_removed, and after_effect_fizzled events to effects for scripters.
4. Added the after_death event to units for scripters.
5. Added shared.CreateUnit, map.AddUnit, and map.RemoveUnit methods for scripters.
6. Added a sanity check that announces when a unit does not  have a valid team number.
7. Added sanity checks that announce when there are no teams or the player's team does not exist rather than crashing.
8. Updated range and dice parsing to be case insensitive.
9. Improved error reporting when parsing ranges or dice.
10. Added contextual help that is accessed by pressing F1 and shift + F1.
11. Added color= flags to team and unit files.
12. Fixed a bug with the terrain_limit= flag.
13. Fixed a bug when using a take skill with a range of more than 0.
14. Added a verbose flag for the game.config file so map creators can hear dice rolls and more in depth information.
15. Added a unique ID to units for scripters as direct object reference comparison does not work in javascript with objects passed to you by the engine.
16. Separated the Map Creation Guide from the main user guide so it is not so overwhelming for new players.
17. Added visuals for menus.
18. Added visuals for items.
19. Made it so all skills show up in the unit menu for enemies.  This way you can press F4 on them to hear the descriptions of enemy skills.
20. Fixed a bug where loading a game after starting the program fresh would cause start turn changes to occur.
21. Made it so that an item is equippable if any of it's equip type names match the unit's equip type names.
22. Made it so unit names used in escape victory conditions or death defeat conditions can match any unit regardless of team.
23. Fixed a bug where units with spaces in their names were not recognized in escape or death conditions.
24. Added the ability to download and install map packs in game.
25. Fixed a few bugs to make downloading map packs in game more solid.
26. Fixed a bug where items that did not have an equip type requirement could not be equipped.
27. Fixed a bug that caused the game to crash when using specific skills on empty tiles.  These skills targetted a tile but caused effects on units.
28. Added the ability to configure many of the game's keys using Keys.config.
29. Added the no_drop_items_on_death flag for units.
30. Hidden points will no longer have start or end of turn changes announced.
31. Added the unit after_create event for scripters.
32. Changed how dictionaries are accessed from javascript to support adding or removing keys from them.
33. Updated dictionaries in javascript so scripters no longer need to prepare strings for indexing before using them as keys.  The engine now handles that itself.
34. Added the shared.GetStorage() method for scripters.
35. Made it so the game gets a different map downloads file based on whether it is a dev or stable version.
36. Fixed a bad memory leak introduced in earlier dev versions.
37. Added Allan Thompson's beginner's guide to map creation to the documentation.
38. Significantly improved the performance of checking for updated map packs by having the server check instead of the client and by caching the result.
39. Added a go to map selection menu in the battle menu.
40. Improved the way sounds were loaded and disposed which greatly improved memory usage.
41. Added an option in preferences to turn off the graphics.
42. Significantly improved TB map rendering performance on large maps.
43. Significantly improved AI performance on large maps.
44. Added the ability to get the lists for units, structures, and effects from a tile object in script.
45. Added the AllUnits property on the shared.Map object for scripters.
46. Added an in game updater that automatically checks for updates to the game and gives the player an option to update.
47. Fixed a bug where a map pack that was missing Map Pack Settings.txt and Author.txt would crash the game.
48. Added the new parser format for most files.  That is parser version 10.
49. Added Event Subscriptions.txt for subscribing to global events.
50. Added the Script Flag Definitions.txt file for scripters.
51. Added the load_scripts flag to the Map Pack Settings.txt file.
52. Added an inherits flag for units, so you can have a base unit that other units inherit flags and script flags from.
53. Added a feature to convert older map pack files to version 10.
54. A number of bug fixes that didn't get properly recorded in the changelog.
55. Significantly reduced the size of saved games and TB memory consumption in general which also improves the speed of saving and loading.
56. (CB) Fixed a bug where specifying cost mods for specific skills didn't work e.g move_actions_cost_mod=2. This should all be fine now.
57. (CB) The AI will no longer use self targeting skills to effect units on the same tile. Self should mean self.
58. (CB) Fixed a bug where skills that caused effects and damage would kill the unit, then apply the effect, then kill it again. This could cause trouble with death transformations and other after_death events.
59. (CB) There is now an only_useable_on flag that works as the opposite to not_useable_on. It will only let you or the AI target given units with that skill or item. In cases where both are used, the game will give you a spoken warning and then use the only_useable_on in preference.
60. Fixed the bug where maps playing synchronous sounds in their intro_text flag would not actually play the sound.
61. Added a battle log that lets you review the enemy's turn at your own pace.
62. Fixed a bug where loading a game would run the javascript code while the global object was in play, thus overwriting some saved data. 
63. Fixed a bug where the current tile would be announced along with sound before the battle log appeared. 

## version 1.12
1. Added ability to specify numbers as ranges or dice rolls for flags related to inflict, restore and protect.
2. Added a chance= flag to skills that takes a number between 1 and 100 to indicate the chance of that skill succeeding.
3. Added the ability to do scripting in the game to add new features.
4. Added a Scripting Guide that documents how to do scripting in Tactical Battle.
5. Made it so that self_effects and self_remove_effects still occur even when a skill fails due to the chance= flag.  This allows an exhaustion effect to still occur on the caster even though the spell failed.
6. Added the ability to have more than one sound associated with a unit's cursor or death sounds and skill sounds.  Each time the game should play one it chooses randomly from the list associated with that sound.
7. Made it so that when a skill fails the game attempts to play the skilName_fail.wav sound instead of the normal sound.
8. Made it so if no fail sound exists for the skill it will play "skill_fail.wav" if one is available.
9. Fixed a bug where defeating a unit that blocked sight would not make the tiles behind it become visible.
10. Fixed a bug where splash effects would announce damage to a particular point even when it was 0.
11. Fixed a bug where if 2 map packs had intro music with the same filename the first music file played when you moved to the second map pack.
12. Added Team files that allow you to configure how many teams exist in your map pack and what names they have as well as how they feel about other teams.
13. Rewrote the way turns were handled to use a new Rounds and Turns system that is easier for everyone to understand.  (This breaks old maps)
14. Added a no_turn Team flag that indicates that team does not get a turn.  Useful for structures that do not belong to a particular team and don't need a turn.
15. Made it so that inflict and restore can be reduced to 0 due to modifiers and protects.
16. Added the following dynamic flags to Effects: health_ignore_max, health_restore, health_splash_restore, health_inflict, health_splash_inflict.
17. Added the splash_range flag to effects.
18. Added the ability to have effect flags affect specific skills.  For example these flags could be used on an effect to affect the attack skill.  attack_health_inflict_mod=, attack_health_restore_mod=, attack_actions_cost_mod=
19. Added a flag for terrain called special that makes it so that terrain is announced when pressing shift + T and the terrain sound is played whenever it becomes visible.
20. Added an allows_actions point flag and the shift + A hot key that announces any of your units who still have points that allow actions.
21. Revised the keys that give information and the ones that take you to the last source or target of an action.  All descriptions of the current unit, terrain and their effects can be obtained by pressing shift + F4.
22. Added the shift + P hot key for cycling through possible targets of the current skill.  Only useable when choosing a target for a skill.
23. Added an announce flag to effects.  If present the game announces whenever that effect is added or removed on a unit.
24. Fixed the bug where AI would not take range modifiers into account when determining if it could use a skill.
25. Added a chance_mod= flag to effects and terrain.
26. Added a sight_range_mod= flag to effects and terrain.
27. Added a hidden flag to Point files that stops them from being announced to players when the F4 key is pressed.
28. Added a not_useable_on= flag to skills.  It takes a comma separated list of unit types that this skill can not be used on.
29. Added a replace_terrain= flag on skills.
30. Added a fizzle_replace_terrain= flag on effects.  Note this does not occur if the effect is removed before it fizzles.
31. Added the ability to create custom items that can be used like skills or equipped to enhance your character and skills.
32. Added the ability to place items in the map editor using the I key.
33. Items are announced when your review cursor moves to a tile that has them and you can press F5 to get a list of the items.
34. Added the equip_slots= flag to Units.
35. Added the ability for items to affect a specific skill when equipped by specifying a skill prefix in front of _range_mod= and _chance_mod= flags as well as any point modifying flags.
36. Added the take_item flag to skills for defining a skill that takes items.
37. Added the useable_once and useable_forever flags to items to define how they should be consumed.
38. Added a manage_equipment flag for skills.
39. Created menus for equipping and unequipping items.
40. Added a ranged flag to items that indicate that range modifiers should affect the unit who equips the item.  Ordinarily the range modifiers are only applied if the unit's base range on a skill is more than 1.
41. Added the replace_skill_sound= flag for items.
42. Included Craig Brett's scripts and documentation.  Most notably he's included a script for charming / controlling / capturing enemy units.
43. Stopped the current tile from announcing right after you use a skill.
44. Moved the map packs into a sub menu of the main menu and removed the word "Play" from the beginning of each map pack name and each map name to facilitate better first letter navigation.
45. Fixed a bug where the shift + P key was not taking positive range modifiers into account.
46. Added the control + R hot key for announcing the current round.
47. Fixed a bug where choosing to use an item would allow you to back out to choose a different item but never let you cancel far enough to not use an item at all.
48. Added the items= unit flag for specifying which items the unit starts with.
49. Updated the equip_slots= unit flag so it can also supply starting equipment.
50. Made it so that when a unit dies all of it's items and equipment are placed on the ground.
51. Added a give_item skill flag.
52. Added a drop_item skill flag.
53. Added the control + shift + R hot key to reload the map editor.  Useful to make the map editor aware of new unit, skill or item files you've added.
54. Fixed a bug where map editor team toggling would only cycle through team numbers 1 and 2.  It now cycles through all defined teams.
55. Moved extra dll files to the lib folder so they don't clutter the root of the game folder.
56. Added equip_type= flags to units and items for handling scenarios like having warriors that can equip heavy plate armor while wizards can not.
57. Fixed a bug where items could not be used to summon units.

## version 1.11
1. Finished removing old point system code which causes maps to report errors if you're still using unsupported flags.  Very useful for ensuring your maps are completely converted to the new system.
2. Added the ai_controlled unit flag to specify that a normally player controlled unit will be AI controlled instead.
3. Added the can_toggle_ai unit flag to allow players to toggle AI on or off for that unit.
4. Added the control + A hot key to force a single unit to take it's AI controlled turn immediately.  Only works if the unit belongs to you and it is either set to AI controlled or you have the ability to toggle whether it's AI controlled or not.
5. Added the control + shift + A hot key to toggle a unit between AI controlled and player controlled.
6. Fixed a bug where a unit would not be removed from the map if it died due to a cost of moving.
7. Added a step_sound= flag for terrain and effects.  This sound is used instead of the normal sound when a unit is moving on to a tile with that effect or terrain.
8. Made it so a map can only reference music in it's own map pack or in the global music folder.  While potentially consuming more space this makes it less confusing for map creators.
9. Added timer= victory and defeat conditions.
10. Fixed a few bugs introduced with the previous feature updates as well as improving the file parsers so they give helpful errors more and crash less.
11. Fixed a bug where the AI would target the wrong unit if multiple units were stacked on the same tile.
12. Fixed the issue where start_turn_change and end_turn_change would bring a unit's health back down to it's max value when it was previously raised above it with a skill that ignored the max.
13. Fixed the issue where inflicting damage to a point the target unit did not have caused that unit to be unable to use any skills.
14. Made it so when AI uses a skill the positions of the caster and the target are announced.
15. Fixed a bug where an AI controlled unit that ran out of points to use a preferred skill would no longer move to somewhere that it could use another skill.
16. Updated the default terrain color to be "WhiteSmoke" so that it is distinguishable from the black of the edge of the map.
17. Made it so the skill with the move_keys flag can only be used through the shift + arrow keys as it is a poor experience to use the move skill from the menu.
18. Added a preferences menu and an option to toggle the Y axis so it increases as it goes up which matches mathematical graphs.
19. Added an option to toggle whether coordinates are announced when AI uses skills, also made it so when this is on it still does not announce coordinates when a player uses skills as that is unnecessary.
20. Added a fog of war concept that makes it so the game can have unseen tiles and unexplored tiles.
21. Added a use_sight_range map flag to enable the new fog of war features.
22. Added a sight_range= unit flag so you can set how far each unit can see.
23. Added logic to incorporate line of sight in determining whether your units can see a tile or not.
24. Added a blocks_sight terrain flag for blocking sight and use of ranged skills due to line of sight restrictions.
25. Added a no_line_of_sight skill flag to allow skills to shoot through terrain that has the blocks_sight flag.
26. Adjusted tile visuals to be square instead of rectangle so line of sight looks more correct for sighted players.
27. Updated sound logic to look for a .mp3 version of the sound if a .wav version was not found.
28. Made it so that when you move a unit and a previously hidden enemy becomes visible it's sound is played or a default alert sound if none exists for that enemy.
29. Added a not_flyable terrain flag that works like impassable but also stops flying units.  Useful when walls are connected to ceilings and even flying units should not be able to pass them.
30. Made it so AI would still move to a position where it could use an action next turn even if it could not perform any actions besides moving this turn.
31. Added an ai_wait_until_enemy_in_sight unit flag to cause AI to do nothing until the first time they spot an enemy.
32. Added a not_affect_flying flag for terrain and tile effects that makes it so flying units are not affected by damage, healing, step costs and range modifiers.
33. Updated line of sight logic so flying units can see over terrain that they can fly over, but not over terrain with both the blocks_sight and not_flyable flags set on them.
34. Added blocks_sight flags to units, structures and tile effects.
35. Replaced the use_sight_range map flag with use_unseen and use_unexplored.
36. Made it so you can specify "none" as a terrain name in the terrain_limit= flag to allow movement on tiles with no terrain.
37. Added the ability for players to save and load games.
38. Added a new Map pack settings.txt file that replaces the old author.txt file and allows you to specify music that plays in your map pack menu.
39. Fixed a bug where protection was not being applied to step inflict, start and end turn damage.
40. Made the defending the river map a little easier as the AI has become smarter since 1.09 and I want the map to remain beatable.

## version 1.10
1. names of units to be defeated in the victory conditions can now include underscores.
2. Removing the defend_enabled flag from default map flags now removes the defend skill and also no longer crashes when the AI runs. (obsolete now)
3. Added a no_self_cast flag for skills.  This can be used on skills that have the friendly flag but are not meant for the caster to use on themselves.
4. Added a "fly" flag for effects so you can add an effect to a unit to allow them to fly while the effect lasts.
5. Added a remove_effects= flag on skills that works just like the effects= flag except that it removes effects rather than adding them.
6. Effects that deal end of turn damage and are applied to units rather than tiles will now cause the damage as expected. (obsolete in the old system though the new system works correctly as well)
7. Added new flags to skills that allow you to hint to the AI at how the skill should be used.  The flags are ai_heal, ai_buff, ai_curse, ai_tile_curse, ai_attack, ai_defend and ai_move.
8. Fixed a bug that would crash the game if the AI used a skill that resulted in it's own death.
9. Fixed a bug where the game ignored the no_movement flag when it is on an effect applied to a passive skill.
10. Made a huge re-write to the point system.  Level creators can now create their own custom points rather than being restricted to the old hard coded HP, MP, and AP.
11. In the new point system there are no hard coded skills such as move, attack and defend.  These are now more customizable by the player so that you can have units who can not attack or move for instance.
12. Implemented a death flag on effects which is used in the new point system.
13. Implemented a hide_old_points flag in the map defaults file to remove all the hard coded points and abilities from a new map.
14. Added the ability to set flags for a skill while in the unit file, this is primarily used to alter how much damage attack does or it's range on a per unit basis as the attack skill is now treated as a normal skill in the new point system.
15. Added a map flag called music that let's you set the music for that map.  Music files can be placed in the "Music" folder of your map pack.
16. Added a skill flag called move_self which is used to support the non-hard coded move skill but can also be used to support teleportation skills.
17. Added a Default unit flags.txt file.
18. Added a new key= flag for skills that allows you to set a hot key for using that skill when your cursor is over a unit.  This only works if you are using the hide_old_points flag on your map.  The revised getting started maps already use this flag to map M to move and A to attack.
19. In maps using the new point system you are now required to move to each tile along the path to your final destination.  This will allow for tiles that have negative effects or terrain to cause damage to you as you first step on to them.
20. To make moving simpler in the new movement system you can use the shift + arrow keys to move one tile in any direction.  Map creators can determine which skill uses these keys by setting the move_keys flag on a skill.
21. Fixed a bug where pressing J or K to cycle through units while in the map editor for a map that had no units for that team would cause the game to crash.
22. Added a self flag for skills that can only be cast on yourself.
23. Added a brand new damage type system.  This allows you to say that a bash skill does physical damage while a fireball does fire damage and then give units armor that may defend against physical but not fire and so forth.
24. Made it so you can have 2 maps with the same name as long as they aren't in the same map pack.  This makes it easier to just copy and paste a map pack and get started editing maps.
25. Added the ability for each map pack to provide it's own user guide.
26. Separated the original user guide into a main menu user guide and one specific to the getting started maps and made heavy updates to the map creation section of the user guide.
27. Added the ability to toggle a unit's team by pressing shift + T when in the map editor.
28. You can now press shift + S to move your cursor back to the last unit who performed an action.  This is very useful when attacking an enemy 3 spaces away as you press shift + B to jump right back to your archer.
29. Added the ability to add structures to maps and updated the in game map editor to let you place structures by pressing S to choose one and spacebar to place it.
30. Added the ability to stack structures or units by setting the units_pert_tile= or structures_per_tile= flags in the default map flags file to something higher than 1.
31. Also updated the in game map editor to support placing stackable units and tiles.
32. Added tab and shift + tab to toggle through units and structures on the current tile.
33. Added an impassable flag for units and structures that stop non flying units or structures from entering their tiles.
34. Added a summon= flag for skills that allows a skill to summon a new unit or structure to the target tile.
35. Added an opposing_forces_can_share_tiles map flag to allow opposing forces to occupy the same tile when stackable units or structures are enabled.
36. Added a splash_range= flag to skills to specify how far the splash damage and effects reach.
37. Added splash_effects= and splash_remove_effects= flags to skills so that the splash can cause or remove effects.
38. Added self_effects= and self_remove_effects= flags to skills so you can have a skill that causes or removes an effect from the caster instead of the target, such as an exhaustion effect on the caster when they use a powerful skill.
39. Added a point_splash_restore= flag to skills to match the point_splash_inflict= flag.
40. Added a point_step_cost= flag to terrain so you can make it cost more movement or actions to move on to that terrain.
41. Added point_step_inflict= and point_step_restore= flags for units, passive skills, effects and terrain.
42. Added a few more AI hint flags for skills, which are ai_uncurse, ai_unbuff and ai_summon and additionally made the AI intelligent enough to use them.
43. Added a sound= flag for effects and added the playing of effect or terrain sounds when moving a character.  Also added playing of tile effects sounds when moving the cursor.
44. Added F3, F4, F5, F6, and F7 for announcing all sorts of information.  Replaces the old C and I keys.
45. Changed a number of keyboard shortcuts to free up the letter keys for map creators to use with skills and to change cycling keys to use the shift key for reversing rather than consuming 2 keys.
46. Added F11 and shift + F11 to adjust music volume without going to the audio settings menu.
47. Updated code so that if a music file fails to load it does not crash the game.  Also updated code to not try and load the desktop.ini file when it exists in the sounds or music folders.
48. Separated the keys that cycle through structures from the ones that cycle through units.
49. Made it so sounds from one map pack would not override those in another map pack.
50. Added F8 key to replay the map intro.
51. Adjusted format of Units, skills, effects and terrain files so flags can be specified on separate lines for better readability and editing.
52. You can now press shift + T to move your cursor back to the last unit you performed an action on.  This is the opposite of shift + S, added earlier and allows you to quickly jump between the source unit and target unit.
53. Fixed a naming conflict bug related to skills and points that had similar names but still unique ones.
54. Added the ignore_max dynamic skill flag for letting skills restore points passed their normal maximums.
55. Fixed a bug where AI would use skills that restored points to units that could not benefit from the points.
56. Fixed a bug where AI would attack a unit that could not suffer that type of point damage.
57. Added the terrain_limit= unit flag for limiting unit movement to certain types of terrain.
58. Added first letter navigation for all menus in the game.
59. Added regions to the game as well as the ability to place them in the map editor.
60. Added the ability to do block placement in the map editor by first marking one corner of the block with the M key and then going to the other corner of the block and pressing shift + space bar.
61. Added a no_skills flag for effects that stops the affected unit from using any skills.
62. Updated the music and sounds for the 5 getting started maps.
63. More heavy updates to the main menu user guide for all the previously mentioned features.
64. Started cleaning up code from the old system which makes it so only maps using the new point system will work in Tactical Battle 1.10 and later.

Written by Ian Reed
